// tests/test_author.cpp
#include <boost/test/auto_unit_test.hpp>
#include "../src/author.hpp"

BOOST_AUTO_TEST_SUITE(Author_test_suite);  
BOOST_AUTO_TEST_CASE(testCtors) {
    cAuthor *author = new cAuthor("Samuel", "Beckett");
    BOOST_CHECK(author->getFirstName() == "Samuel");
    BOOST_CHECK(author->getLastName() == "Beckett");
    delete author;
}
BOOST_AUTO_TEST_CASE(testEmptyAuthorException) {
    cAuthor *author = 0;
    BOOST_CHECK_THROW(author = new cAuthor("", ""), 
                      cInvalidAuthor);
    if (author != 0) delete author;
}
BOOST_AUTO_TEST_SUITE_END();
