#include <fstream>
#include <boost/test/results_collector.hpp>
#include <boost/test/results_reporter.hpp>
#include <boost/test/output/xml_report_formatter.hpp>
#include <boost/test/utils/xml_printer.hpp>
#include <boost/test/unit_test.hpp>
#include <boost/version.hpp>

using namespace boost::unit_test;

class my_xml_report_formatter : public output::xml_report_formatter {
public:	
	my_xml_report_formatter();
private:
	bool any_fail;
	void results_report_start(std::ostream& ostr);
	void results_report_finish(std::ostream& ostr);
	void build_info(std::ostream& ostr);
	void run_info(std::ostream& ostr);
	void test_unit_report_start(test_unit const& tu, 
                                std::ostream& ostr);
};


my_xml_report_formatter::my_xml_report_formatter() : any_fail(false) {
	xml_report_formatter();
}

void 
my_xml_report_formatter::results_report_start(std::ostream& ostr) {
	ostr << "<?xml version=\"1.0\" encoding='ISO-8859-1' " \
			"standalone='yes' ?>";
	ostr << "<?xml-stylesheet type=\"text/xsl\" " \
			"href=\"unittestreport.xsl\"?>";
	output::xml_report_formatter::results_report_start(ostr);
	build_info(ostr);
	run_info(ostr);
}

void 
my_xml_report_formatter::results_report_finish(std::ostream& ostr) {
	ostr << "<TestSummary"
		 << " pass" << attr_value() << (any_fail ? 0 : 1)
		 << "/>";
	xml_report_formatter::results_report_finish(ostr);
}

void 
my_xml_report_formatter::build_info(std::ostream& ostr) {
	ostr << "<BuildInfo"
		 << " platform"  << attr_value() << BOOST_PLATFORM
		 << " compiler"  << attr_value() << BOOST_COMPILER
		 << " stl"       << attr_value() << BOOST_STDLIB
		 << " boost=\""  << BOOST_VERSION/100000     << "."
						  << BOOST_VERSION/100 % 1000 << "."
						  << BOOST_VERSION % 100      << '\"'
		 << "/>";
}

void
my_xml_report_formatter::run_info(std::ostream& ostr) {
	ostr << "<CompileInfo" 
		 << " date" << attr_value() << __DATE__ 
		 << " time" << attr_value() << __TIME__ 
		 << "/>";
}

void
my_xml_report_formatter::test_unit_report_start(test_unit const& tu, 
                                                std::ostream& ostr) {
	test_results const& tr = results_collector.results(tu.p_id);	
	any_fail |= !tr.passed();
	xml_report_formatter::test_unit_report_start(tu, ostr);
}

std::ofstream file("unittestreport.xml");

namespace testauthor {
test_suite *get_test_suite();
}
namespace testbook {
test_suite *get_test_suite();
}

test_suite*
init_unit_test_suite( int, char* [] ) {	
	results_reporter::set_stream(file);
	results_reporter::set_format(CLF);
	results_reporter::set_level(DETAILED_REPORT);
	results_reporter::set_format(new my_xml_report_formatter);

    test_suite* test = BOOST_TEST_SUITE( "Main test suite" );
	test->add(testauthor::get_test_suite());
	test->add(testbook::get_test_suite());
	return test;
}
