// unittests.cpp
#include <exception>
#include <boost/test/unit_test.hpp>
#include "author.hpp"
#include <boost/test/floating_point_comparison.hpp>
using namespace boost::unit_test;



class cTestException {
public:
    cTestException(int i) : m_value(i) { }
    int GetValue(void) { return m_value; }
private:
    int m_value;
};
bool ExceptionInspector(cTestException e) {
    return e.GetValue() == 0;
}
void TestFunctionA(void) {
    BOOST_CHECK_EXCEPTION(throw cTestException(0), 
                          cTestException, ExceptionInspector);
    BOOST_CHECK_EXCEPTION(throw cTestException(1),
                          cTestException, ExceptionInspector);
}














void TestFunctionC(void) {
    cAuthor *author1 = new cAuthor("Graham", "Greene");
    cAuthor *author2 = new cAuthor("Samuel", "Beckett");
    cAuthor *author3 = new cAuthor("Samuel", "Beckett");
    BOOST_CHECK_EQUAL(*author1, *author2);
    BOOST_CHECK_EQUAL(*author2, *author3);
}
bool operator==(cAuthor a1, cAuthor a2) {
    return a1.getFirstName() == a2.getFirstName() 
        && a1.getLastName() == a2.getLastName(); 
}
std::ostream& operator<<(std::ostream& str, cAuthor a) {
    str << '<' << a.getFirstName()  << ' ' 
        << a.getLastName() << '>';
    return str;
}




bool isSorted(int a, int b, int c) { 
    return c > b && b > a;
}
void TestFunctionD(void) {
    int a = 5; 
    int b = 3;
    BOOST_CHECK(isSorted(a, b, 7));
    BOOST_CHECK_PREDICATE( isSorted, (a)(b)(7));
}











bool operator!=(cAuthor a1, cAuthor a2) {
    return a1.getFirstName() != a2.getFirstName() 
        || a1.getLastName() != a2.getLastName(); 
}
void TestFunctionE(void) {
    cAuthor A[] = { cAuthor("Graham", "Greene"), 
                    cAuthor("Samuel", "Beckett") };
    cAuthor B[] = { cAuthor("Graham", "Greene"), 
                    cAuthor("Samuel", "Beckett") };
    BOOST_CHECK_EQUAL_COLLECTIONS(A, A+2, B, B+2);
}

//________________________________________________________

class cCounter{
public:
    cCounter(int i) : m_value(i) { }
    int GetValue(void) const { return m_value; }
    int SetValue(int i) { m_value = i; }
#if 0
    bool operator==(cCounter const &c) const { return c.m_value == m_value; }
    friend std::ostream& operator<<(std::ostream& str, cCounter const& c) {
        str << '<' << c.GetValue() << '>';
        return str;
    }
#endif
private:
    int m_value;
};

bool operator==(cCounter const &c1, cCounter const &c2) { return c1.GetValue() == c2.GetValue(); }
std::ostream& operator<<(std::ostream& str, cCounter const& c) {
    str << '<' << c.GetValue() << '>';
    return str;
}

void TestFunctionB(void) {
    char StrA[] = "SLLegen";
    char StrB[] = "Regen";
    cCounter CntA(0);
    cCounter CntB(1);
    cCounter CntC(2);
    
    CntA.SetValue(1);
    BOOST_CHECK_EQUAL(12, 12);
    BOOST_CHECK_EQUAL(&StrA[3], &StrB[1]);
    BOOST_CHECK_EQUAL(CntA, CntB);
    BOOST_CHECK_EQUAL(CntA, CntC);
}
//________________________________________________________


void TestFunction2(void) {
    //BOOST_CHECK_NO_THROW(throw cTestException(0));
#    if 0
    double v1 = 1.23456e-10;
    double v2 = 1.23457e-10;

    BOOST_CHECK_CLOSE( v1, v2, 0.0001 );
#    endif
    
    int a = 0x0100;
    int b = 0x0300;
    BOOST_CHECK_BITWISE_EQUAL(1, 2);

    
}

test_suite* init_unit_test_suite( int, char* [] ) {
    test_suite* test = BOOST_TEST_SUITE( "Main test suite" );
    //test->add(BOOST_TEST_CASE(&TestFunctionA));
    //test->add(BOOST_TEST_CASE(&TestFunctionB));
    //test->add(BOOST_TEST_CASE(&TestFunctionC));
    //test->add(BOOST_TEST_CASE(&TestFunctionD));
    test->add(BOOST_TEST_CASE(&TestFunctionE));
    return test; 
}
