// tests/test_book.cpp
#include <cppunit/extensions/HelperMacros.h>
#include "../src/author.hpp"
#include "../src/book.hpp"

class cTestBook : public CppUnit::TestFixture {
private:
    cAuthor *author1, *author2;
    cBook *book;

    CPPUNIT_TEST_SUITE(cTestBook);
    CPPUNIT_TEST(testCtors);
    CPPUNIT_TEST(testSetAuthor);
    CPPUNIT_TEST_SUITE_END();

public:
    void setUp(void) {
        author1 = new cAuthor("Samuel", "Beckett");
        author2 = new cAuthor("Graham", "Greene");
        book = new cBook("Endspiel", *author1);
    }

    void tearDown(void) {
        delete book;
        delete author1;
        delete author2;
    }

    void testCtors(void) {
        cAuthor myauthor("Samuel", "Beckett");
        cBook mybook("Endspiel", myauthor);
        CPPUNIT_ASSERT(mybook.getTitle() == "Endspiel");
        CPPUNIT_ASSERT(mybook.getAuthor().getFirstName()
        	== "Samuel");
        CPPUNIT_ASSERT(mybook.getAuthor().getLastName()
        	== "Beckett");
    }

    void testSetAuthor(void) {
        book->setAuthor(*author2);
        CPPUNIT_ASSERT(book->getTitle() == "Endspiel");
        CPPUNIT_ASSERT(book->getAuthor().getFirstName()
        	== "Graham");
        CPPUNIT_ASSERT(book->getAuthor().getLastName()
        	== "Greene");
        book->setAuthor(*author1);
    }

};

CPPUNIT_TEST_SUITE_REGISTRATION(cTestBook);
