#include <windows.h>
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestCaller.h>

#define CPPUNIT_TEST_STOPWATCH(testMethod, TimeLimit) \
    CPPUNIT_TEST_SUITE_ADD_TEST( \
        (new cStopWatchTestCaller<TestFixtureType>( \
            context.getTestNameFor(#testMethod), \
            &TestFixtureType::testMethod, \
            context.makeFixture(), TimeLimit ) ) )

template<class Fixture>
class cStopWatchTestCaller : public CppUnit::TestCaller<Fixture> {
private:            
    typedef void(Fixture::* TestMethod )();
    float m_timelimit;
public:
    cStopWatchTestCaller(std::string name, TestMethod test, 
                         Fixture *fixture, float timelimit) 
        : CppUnit::TestCaller<Fixture>(name, test, fixture), 
          m_timelimit(timelimit) {}
private:
    void runTest() {
        LARGE_INTEGER p0, p1, pf;
        QueryPerformanceFrequency(&pf);
        QueryPerformanceCounter(&p0);
        CppUnit::TestCaller<Fixture>::runTest();
        QueryPerformanceCounter(&p1);
        float t = (float)p1.QuadPart - (float)p0.QuadPart;
        t /= (float)pf.QuadPart;
        CPPUNIT_ASSERT_MESSAGE("Time limit", t <= m_timelimit);
    }
};

class PerformanceTest : public CppUnit::TestFixture {
public:
    CPPUNIT_TEST_SUITE(PerformanceTest);
    CPPUNIT_TEST_STOPWATCH(testSortBooks, 1.0);
    CPPUNIT_TEST_SUITE_END();
    void testSortBooks();
};
CPPUNIT_TEST_SUITE_REGISTRATION(PerformanceTest);

void PerformanceTest::testSortBooks() {
    Sleep(2000);
    std::cout << "testSortBooks" << std::endl;
}

 
