// src/author.hpp
#ifndef AUTHOR_HPP_
#define AUTHOR_HPP_
#include <string>

class cInvalidAuthor {};

class cAuthor {
public:
    cAuthor(std::string const &firstname,
            std::string const &lastname)
            : m_firstname(firstname), m_lastname(lastname) {
        if (firstname.empty() or lastname.empty())
            throw cInvalidAuthor() ;
    }
    std::string getFirstName(void) { return m_firstname; }
    std::string getLastName(void)  { return m_lastname;  }
private:
    std::string m_firstname;
    std::string m_lastname;
};
#endif /*AUTHOR_HPP_*/
