// tests/test_author.cpp
#include <cppunit/extensions/HelperMacros.h>
#include "../src/author.hpp"

class cTestAuthor : public CppUnit::TestFixture {
private:
    cAuthor *author;

    CPPUNIT_TEST_SUITE(cTestAuthor);
    CPPUNIT_TEST(testCtors);
    CPPUNIT_TEST_EXCEPTION(testEmptyAuthorException,
        cInvalidAuthor);
    CPPUNIT_TEST_SUITE_END();

public:
    void testCtors(void) {
        author = new cAuthor("Samuel", "Beckett");
        CPPUNIT_ASSERT(author->getFirstName() == "Samuel");
        CPPUNIT_ASSERT(author->getLastName() == "Becket");
        delete author;
    }

    void testEmptyAuthorException(void) {
        author = new cAuthor("", "");
        delete author;
    }
};

CPPUNIT_TEST_SUITE_REGISTRATION(cTestAuthor);
