// tests/unittests.cpp
#include <iostream>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/TextTestRunner.h>
#include <cppunit/XmlOutputter.h>
#include <cppunit/XmlOutputterHook.h>
#include <cppunit/tools/XmlElement.h>
#include <cppunit/tools/XmlDocument.h>

using namespace CppUnit;

class MyXmlOutputterHook : public XmlOutputterHook {
public:
    MyXmlOutputterHook::MyXmlOutputterHook() : any_fail(false) {}
    void endDocument(XmlDocument* document) {
        if (!document) return;
        XmlElement* item = new XmlElement("Info", "");    
        item->addElement(new XmlElement("date", __DATE__));
        item->addElement(new XmlElement("time", __TIME__));
        document->rootElement().addElement(item);
        document->rootElement().addElement(
          new XmlElement("TestSummary", any_fail ? "fail" : "pass"));
    }
    void failTestAdded(XmlDocument *document, XmlElement *testElement, 
        Test *test, TestFailure *failure) { any_fail = true; }
private:
    bool any_fail;
};

int main() {
    TextTestRunner runner;
    std::ofstream file("unittests.xml");
    XmlOutputter *outputter = 
        new XmlOutputter(&runner.result(), file);
    outputter->setStyleSheet("report.xsl");
    outputter->addHook(new MyXmlOutputterHook);
    runner.setOutputter(outputter);
    runner.addTest(TestFactoryRegistry::getRegistry().makeTest());
    int result = static_cast<int>(!runner.run());
    file.close();
    return result;
}
