/** @file */

/**
 * @brief Berechne x^n
 * @param x Basis
 * @param n Exponent
 * @return x^n
 * @exception overflow_error
 *   mathematischer berlauf
 * @exception underflow_error
 *    mathematischer Unterlauf
 *
 * Die Funktion berechnet x^n fuer Gleitkommawerte x 
 * und ganzzahlige Exponenten n.
 */
double power(double x, int n) 
       throw(overflow_error, underflow_error);
       
/** 
 * @brief Prfung auf gltige IP-Adresse
 * @param s Zeichenkette mit IP-Adresse (dotted decimal)
 * @retval false wenn IP-Adresse ungltig
 * @retval true  wenn IP-Adresse gltig ist
 */
bool is_valid_ip(const char *s);