# Dies sind Beispieldateien zum Buch 
# 
# Achim Khler. Der C/C++-Projektbegleiter - C/C++ Projekte planen, dokumentieren, 
# bauen und testen. dpunkt.verlag GmbH, 2007.
# ISBN-10 3-89864-470-7
# ISBN-13 978-3-89864-470-9
# http://www.dpunkt.de/buecher/3-89864-470-7.html
# 
# Copyright (C) 2007 Achim Koehler
# Verffentlicht unter der Boost Software License, Version 1.0. 
# (Siehe begleitende Datei  LICENSE_1_0.txt oder eine Kopie unter 
# http://www.boost.org/LICENSE_1_0.txt)
# 
# Diese Beispieldateien gehren zum Kapitel 
# "Programme bauen mit make", 
# Seite 121: Einfhrendes Beispiel, Make-Datei fr Visual C++.

TARGET = demo.exe
CC = cl
LINK = link
CFLAGS = /Wall /nologo /I. 
GGO = gengetopt
RM = cmd /C del


$(TARGET): main.obj cmdline.obj helper.obj getopt.obj \
            getopt1.obj
	$(LINK) /OUT:$@ main.obj cmdline.obj helper.obj \
                      getopt.obj getopt1.obj

main.obj: main.c cmdline.h helper.h
	$(CC) $(CFLAGS) /c $<

cmdline.obj: cmdline.c cmdline.h
	$(CC) $(CFLAGS) /c $<

helper.obj: helper.c helper.h
	$(CC) $(CFLAGS) /c $<

cmdline.c cmdline.h: cmdline.ggo
	$(GGO) -i $< --unamed-opts
	
getopt.obj:	getopt.c
	$(CC) $(CFLAGS) /D HAVE_STRING_H /c $<
	
getopt1.obj:	getopt1.c
	$(CC) $(CFLAGS) /D HAVE_STRING_H /c $<
	

.PHONY: clean doc

doc:
	doxygen 

clean:
	-$(RM) main.obj helper.obj cmdline.obj getopt.obj \
           getopt1.obj cmdline.c cmdline.h

