/* main1.cc */
/* we try to use gengetopt generated file in a C++ program */
/* we don't use autoconf and automake vars */

#include <stdio.h>
#include <stdlib.h>

#include <writer.h>

#include "cmdline.h"
#include "reader.h"


int
main (int argc, char **argv)
{
  struct gengetopt_args_info args_info;
  int i;

  puts("This one is from a C program");
  puts("Try to launch me with some options");
  puts("(type demo --help for the complete list)");
  puts("For example: ./demo *.* --funct-opt");

  /* let's call our cmdline parser */
  if (cmdline_parser (argc, argv, &args_info) != 0)
    exit(1) ;

  puts("Here are the options you passed...");

  
  
  for ( i = 0 ; i < args_info.inputs_num ; ++i )
    printf("file: %s\n",  args_info.inputs[i]);

  if ( args_info.funct_opt_given )
    puts("You chose --funct-opt or -F.");

  if ( args_info.str_opt_given )
    printf("You inserted %s for --str-opt option.\n", args_info.str_opt_arg);

  if ( args_info.int_opt_given )
    printf("This is the integer you input: %d.\n", args_info.int_opt_arg);

  if (args_info.flag_opt_given)
    puts("The flag option was given!");

  printf("The flag is %s.\n", ( args_info.flag_opt_flag ? "on" : "off" ));

  printf("%s!\n", args_info.def_opt_arg);

  puts("Have a nice day! :-)");

  cmdline_parser_free (&args_info); /* release allocated memory */

  reader();
  
  return 0;
}

/*Test*/ 
